	function w = BARTLETT_WINDOW(N)
 	%
	%	Computes the Bartlett window of length N+1
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2008-07-12
	% 	Modified by: 	 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1		 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	M = N+1;
	for n = 1:M
		if n <= M/2
			w(n) = 2*(n+0.5)/M;
		else
			w(n) = -2*(n-M-1.5)/M;
		end
	end

